If you call `GetType()` on a `Type` variable, the return value will always be `typeof(System.Type)`. So there's no
real point in making that call. The same applies to passing a type argument to `IsInstanceOfType`. In both cases the results are entirely
predictable.

## Noncompliant Code Example

<pre>
var type = typeof(int);
var ttype = type.GetType(); //Noncompliant, always typeof(System.Type)

var s = "abc";

if (s.GetType().IsInstanceOfType(typeof(string))) //Noncompliant; false
{ /* ... */ }
</pre>

## Compliant Solution

<pre>
var s = "abc";

if (s.GetType().IsInstanceOfType("ssss"))
{ /* ... */ }
</pre>