Calling `GetType()` on a nullable object returns the underlying value type. Thus, comparing the returned `Type` object to
`typeof(Nullable<SomeType>)` doesn't make sense. The comparison either throws an exception or the result can be known at compile
time.

## Noncompliant Code Example

<pre>
int? nullable = 42;
bool comparison = nullable.GetType() == typeof(Nullable
 <int>
  ); // Noncompliant, always false
comparison = nullable.GetType() != typeof(Nullable
  <int>
   ); // Noncompliant, always true nullable = null; comparison = nullable.GetType() != typeof(Nullable
   <int>
    ); // Noncompliant, calling GetType on a null always throws an exception 
   </int>
  </int>
 </int></pre>