It is expected that some methods should be called with caution, but others, such as `ToString`, are expected to "just work". Throwing an
exception from such a method is likely to break callers' code unexpectedly.

An issue is raised when an exception is thrown from any of the following: 

*   Event accessors
*   `Object.Equals`
*   `IEquatable.Equals`
*   `GetHashCode`
*   `ToString`
*   `static` constructors
*   `IDisposable.Dispose`
*   `operator ==, !=, <, >, <=, >=`
*   `implicit` cast operators

## Noncompliant Code Example

<pre>
public override string ToString()
{
  if (string.IsNullOrEmpty(Name))
  {
    throw new ArgumentException("...");  // Noncompliant
  }
  //...
</pre>

## Exceptions

`System.NotImplementedException` and its derivatives are ignored.

`System.InvalidOperationException`, `System.NotSupportedException`, and `System.ArgumentException` and their
derivatives are ignored in event accessors.