Using upper case literal suffixes removes the potential ambiguity between "1" (digit 1) and "l" (letter el) for declaring literals.

## Noncompliant Code Example

<pre>
const long b = 0l;      // Noncompliant
</pre>

## Compliant Solution

<pre>
const long b = 0L;
</pre>

## See

*   MISRA C++:2008, 2-13-4 - Literal suffixes shall be upper case
*   MISRA C:2012, 7.3 - The lowercase character "l" shall not be used in a literal suffix
*   [CERT DCL16-C.](https://www.securecoding.cert.org/confluence/x/koAtAQ) - Use "L," not "l," to indicate a long value
*   [CERT DCL16-CPP.](https://www.securecoding.cert.org/confluence/x/n4AtAQ) - Use "L," not "l," to indicate a long value
*   [CERT, DCL50-J.](https://www.securecoding.cert.org/confluence/x/hYClBg) - Use visually distinct identifiers