# [Potential XPath Injection](http://find-sec-bugs.github.io/bugs.htm#XPATH_INJECTION)

XPath injection risks are similar to SQL injection. If the XPath query contains untrusted user input, the complete data source
could be exposed. This could allow an attacker to access unauthorized data or maliciously modify the target XML.

**References**  

[WASC-39: XPath Injection](http://projects.webappsec.org/w/page/13246963/SQL%20Injection)  

[OWASP: Top 10 2013-A1-Injection](https://www.owasp.org/index.php/Top_10_2013-A1-Injection)  

[CWE-643: Improper Neutralization of Data within XPath Expressions ('XPath Injection')](http://cwe.mitre.org/data/definitions/643.html)  

[CERT: IDS09-J. Prevent XPath Injection (archive)](https://www.securecoding.cert.org/confluence/pages/viewpage.action?pageId=61407250)  

[Black Hat Europe 2012: Hacking XPath 2.0](http://media.blackhat.com/bh-eu-12/Siddharth/bh-eu-12-Siddharth-Xpath-WP.pdf)  

[Balisage.net: XQuery Injection](http://www.balisage.net/Proceedings/vol7/html/Vlist02/BalisageVol7-Vlist02.html)