## Hardcoded binding to all interfaces

### Problematic:

```python
s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.bind(('0.0.0.0', 31137))
```

### Correct:

```python
s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
s.bind(('192.168.0.1', 31137))
```

### Rationale:
Binding to all network interfaces can potentially open up a service to traffic on unintended interfaces, that may not be properly documented or secured.

[Reference](https://docs.openstack.org/bandit/latest/plugins/b104_hardcoded_bind_all_interfaces.html)


