## Missing certificate validation

### Problematic:


```python
requests.get('https://gmail.com', verify=False)
```


### Correct:

```python
requests.get('https://gmail.com', verify=True)
```

### Rationale:

When request methods are used, certificates are validated automatically which is the desired behavior.
Turning off certificate validation is a security issue.

[Reference](https://docs.openstack.org/bandit/latest/plugins/b501_request_with_no_cert_validation.html)