## Avoid starting a process with a shell

Python possesses many mechanisms to invoke an external executable. 
However, doing so may present a security issue if appropriate care is not taken to sanitize any user provided or variable input.
This test looks for the spawning of a subprocess using a command shell. 
This type of subprocess invocation is dangerous as it is vulnerable to various shell injection attacks. Great care should be taken to sanitize all input in order to mitigate this risk. 

[Reference](https://docs.openstack.org/bandit/latest/plugins/b605_start_process_with_a_shell.html)