## Avoid partially qualified paths

Python provides a number of methods that emulate the behavior of standard Linux command line utilities. 
Like their Linux counterparts, these commands may take a wildcard “*” character in place of a file system path. This is interpreted to mean “any and all files or folders” and can be used to build partially qualified paths, such as “/home/user/*”.
The use of partially qualified paths may result in unintended consequences if an unexpected file or symlink is placed into the path location given. This becomes particularly dangerous when combined with commands used to manipulate file permissions or copy data off of a system.

[Reference](https://docs.openstack.org/bandit/latest/plugins/b609_linux_commands_wildcard_injection.html)