### AbstractTypesShouldNotHavePublicConstructorsRule
This rule fires if an **abstract** type has a **public** constructor. This is a bit misleading because the constructor can only be called by the constructor of a derived type. To make the type's semantics clearer make the constructor **protected**.

**Bad** example:

``` csharp
abstract public class MyClass {
    public MyClass ()
    {
    }
}
```
**Good** example:

``` csharp
abstract public class MyClass {
    protected MyClass ()
    {
    }
}
```