### ArrayFieldsShouldNotBeReadOnlyRule
This rule warns if a type declares a public **readonly** array field. Marking a field **readonly** only prevents the field from being assigned a different value, the object itself can still be changed. This means, that the elements inside the array can still be changed.

**Bad** example:

``` csharp
class Bad {
    public readonly string[] Array = new string[] { "A", "B" };
}
 
HasPublicReadonlyArray obj = HasPublicReadonlyArray ();
obj.Array[0] = "B"; // valid
```
**Good** example:

``` csharp
class Good {
    private readonly string[] array = new string[] { "A", "B" };
    public string[] GetArray ()
    {
        return (string []) array.Clone();
    }
}
 
string[] obj = new HasPublicReadonlyArray ().GetArray ();
obj [0] = "B"; // valid, but has no effect on other users
```