### AvoidAlwaysNullFieldRule
A type has a private field whose value is always null.

**Bad** example:

``` csharp
internal sealed class Bad {
    private List<int> values;
 
    public List<int> Values {
        get {
            return values;
        }
    }
}
```
**Good** example:

``` csharp
internal sealed class Good {
    private List<int> values = new List<int>();
 
    public List<int> Values {
        get {
            return values;
        }
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.4
