### AvoidCallingProblematicMethodsRule
This rule warns about methods that calls into potentially dangerous API of the .NET framework. If possible try to avoid the API (there are generally safer ways to do the same) or at least make sure your code can be safely called from others.

-   **System.GC::Collect()**
-   **System.Threading.Thread::Suspend()** and **Resume()**
-   **System.Runtime.InteropServices.SafeHandle::DangerousGetHandle()**
-   **System.Reflection.Assembly::LoadFrom()**, **LoadFile()** and **LoadWithPartialName()**
-   **System.Type::InvokeMember()** when used with **BindingFlags.NonPublic**

**Bad** example:

``` csharp
public void Load (string filename)
{
    Assembly a = Assembly.LoadFile (filename);
    // ...
}
```
**Good** example:

``` csharp
public void Load (string filename)
{
    AssemblyName aname = AssemblyName.GetAssemblyName (filename);
    // ensure it's the assembly you expect (e.g. public key, version...)
    Assembly a = Assembly.Load (aname);
    // ...
}
```
**Notes**

-   This rule is available since Gendarme 2.0
