### AvoidConstructorsInStaticTypesRule
This rule checks for types that contain only static members and fires if the type contains a visible instance constructor. This was a common mistake in the 1.x framework because C# adds a default, public, constructor if no other constructors are provided. Code using the framework 2.0 (and later) should change this type, if possible, into a static type.

**Bad** example:

``` csharp
// it is possible to instantiate this class since the
// C# compiler adds a default, public, constructor
public class Class {
    public static void Method ()
    {
    }
}
```
**Good** example:

``` csharp
public class Class {
    // this class cannot be instantiated
    private Class ()
    {
    }
 
    public static void Method ()
    {
    }
}
```