### AvoidDeepNamespaceHierarchyRule
This rule checks for deeply nested namespaces within an assembly. It will warn if the depth is greater than four (default value) unless the fifth (or the next) part is one of the specialized name that the framework recommends or a name like an internal namespace (something not meant to be seen outside the assembly).

-   **Design** : Namespace that provides design-time support for its base namespace.
-   **Interop** : Namespace that provides all interoperability code (e.g. p./invokes) for its base namespace.
-   **Permissions** : Namespace that provides all custom permissions for its base namespace.
-   **Internal** : Namespace that provides non visible (outside the assembly) helper code for its base namespace. **Impl** while allowed by the rule is not encouraged.

**Bad** example:

``` csharp
namespace One.Two.Three.Four.Five {
    internal class Helper {
    }
}
```
**Good** example:

``` csharp
namespace One.Two.Three.Four {
    internal class FiveHelper {
    }
}
```
**Good** example (exception for some namespace specialization):

``` csharp
namespace One.Two.Three.Four.Internal {
    internal class Helper {
    }
}
```
**Configuration**

Some elements of this rule can be customized to better fit your needs.

#### MaxDepth
The depth at which namespaces may be nested without triggering a defect.
