### AvoidLongMethodsRule
This rule allows developers to measure the method size. The short sized methods allows you to maintain your code better, if you have long sized methods perhaps you have the Long Method smell. The rule will skip some well known methods, because they are autogenerated:

-   **Gtk.Bin::Build ()**
-   **Gtk.Window::Build ()**
-   **Gtk.Dialog::Build ()**
-   **System.Windows.Forms::InitializeComponents ()**

This will work for classes that extend those types. If debugging symbols (e.g. Mono .mdb or MS .pdb) are available then the rule will compute the number of logical source line of code (SLOC). This number represent the lines where 'SequencePoint' are present in the code. By default the maximum SLOC is defined to 40 lines. Otherwise the rule falls back onto an IL-SLOC approximation. It's quite hard to determine how many SLOC exists based on the IL (e.g. LINQ). The metric being used is based on a screen (1024 x 768) full of source code where the number of IL instructions were counted. By default the maximum number of IL instructions is defined to be 165.

**Bad** example:

``` csharp
public void LongMethod ()
{
    Console.WriteLine ("I'm writting a test, and I will fill a screen with some useless code");
    IList list = new ArrayList ();
    list.Add ("Foo");
    list.Add (4);
    list.Add (6);
 
    IEnumerator listEnumerator = list.GetEnumerator ();
    while (listEnumerator.MoveNext ()) {
        Console.WriteLine (listEnumerator.Current);
    }
 
    try {
        list.Add ("Bar");
        list.Add ('a');
    }
    catch (NotSupportedException exception) {
        Console.WriteLine (exception.Message);
        Console.WriteLine (exception);
    }
 
    foreach (object value in list) {
        Console.Write (value);
        Console.Write (Environment.NewLine);
    }
 
    int x = 0;
    for (int i = 0; i < 100; i++) {
        x++;
    }
    Console.WriteLine (x);
 
    string useless = "Useless String";
    if (useless.Equals ("Other useless")) {
        useless = String.Empty;
        Console.WriteLine ("Other useless string");
    }
 
    useless = String.Concat (useless," 1");
    for (int j = 0; j < useless.Length; j++) {
        if (useless[j] == 'u') {
            Console.WriteLine ("I have detected an u char");
            } else {
                Console.WriteLine ("I have detected an useless char");
            }
        }
 
        try {
            foreach (string environmentVariable in Environment.GetEnvironmentVariables ().Keys) {
                Console.WriteLine (environmentVariable);
            }
        }
        catch (System.Security.SecurityException exception) {
            Console.WriteLine (exception.Message);
            Console.WriteLine (exception);
        }
 
        Console.WriteLine ("I will add more useless code !!");
        try {
            if (!(File.Exists ("foo.txt"))) {
                File.Create ("foo.txt");
                File.Delete ("foo.txt");
            }
        }
        catch (IOException exception) {
            Console.WriteLine (exception.Message);
            Console.WriteLine (exception);
        }
    }
```
**Good** example:

``` csharp
public void ShortMethod ()
{
    try {
        foreach (string environmentVariable in Environment.GetEnvironmentVariables ().Keys) {
            Console.WriteLine (environmentVariable);
        }
    }
    catch (System.Security.SecurityException exception) {
        Console.WriteLine (exception.Message);
        Console.WriteLine (exception);
    }
}
```