### AvoidMessageChainsRule
This rule checks for the Message Chain smell. This can cause problems because it means that your code is heavily coupled to the navigation structure.

**Bad** example:

``` csharp
public void Method (Person person)
{
    person.GetPhone ().GetAreaCode ().GetCountry ().Language.ToFrench ("Hello world");
}
```
**Good** example:

``` csharp
public void Method (Language language)
{
    language.ToFrench ("Hello world");
}
```