### AvoidMethodWithUnusedGenericTypeRule
This method will fire if a generic method does not use all of its generic type parameters in the formal parameter list. This usually means that either the type parameter is not used at all in which case it should be removed or that it's used only for the return type which is problematic because that prevents the compiler from inferring the generic type when the method is called which is confusing to many developers.

**Bad** example:

``` csharp
public class Bad {
    public string ToString<T> ()
    {
        return typeof (T).ToString ();
    }
 
    static void Main ()
    {
        // the compiler can't infer int so we need to supply it ourselves
        Console.WriteLine (ToString<int> ());
    }
}
```
**Good** example:

``` csharp
public class Good {
    public string ToString<T> (T obj)
    {
        return obj.GetType ().ToString ();
    }
 
    static void Main ()
    {
        Console.WriteLine (ToString (2));
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.2
