### AvoidPropertiesWithoutGetAccessorRule
This rule fires if an externally visible type contains a property with a setter but not a getter. This is confusing to users and can make it difficult to use shared objects. Instead either add a getter or make the property a method.

**Bad** examples:

``` csharp
public double Seed {
    // no get since there's no use case for it
    set {
        seed = value;
    }
}
 
public sting Password {
    // no get as we don't want to expose the password
    set {
        password = value;
    }
}
```
**Good** examples:

``` csharp
public double Seed {
    get {
        return seed;
    }
    set {
        seed = value;
    }
}
 
public void SetPassword (string value)
{
    password = value;
}
```