### AvoidRedundancyInTypeNameRule
This rule will fire if a type is prefixed with the last component of its namespace. Using prefixes like this makes type names more verbose than they need to be and makes them harder to use with tools like auto-complete. Note that an exception is made if removal of the prefix would cause an ambiguity with another type. If this is the case the rule will not report a defect.

**Bad** example:

``` csharp
namespace Foo.Lang.Compiler {
    public class CompilerContext {
    }
}
```
``` csharp
using Foo.Lang;
...
Compiler.CompilerContext context = new Compiler.CompilerContext ();
```
``` csharp
using Foo.Lang.Compiler;
...
CompilerContext context = new CompilerContext ();
```
**Good** example:

``` csharp
namespace Foo.Lang.Compiler {
    public class Context {
    }
}
```
``` csharp
using Foo.Lang;
...
Compiler.Context context = new Compiler.Context ();
```
``` csharp
using Foo.Lang.Compiler;
...
Context context = new Context ();
```
Another good example (more meaningful term in the context of the namespace):

``` csharp
namespace Foo.Lang.Compiler {
    public class CompilationContext {
    }
}
```