### AvoidSmallNamespaceRule
This rule fires if a namespace contains less than five (by default) visible types. Note that this rule enumerates the types in all the assemblies being analyzed instead of simply considering each assembly in turn. The rule exempts:

-   **specialized namespaces** : e.g. **\*.Design**, **\*.Interop** and **\*.Permissions**
-   **internal namespaces** : namespaces without any visible (outside the assemble) types
-   **small assemblies** : that contains a single namespace but less than the minimal number of types (e.g. addins)
-   **assembly entry point** : the namespace of the type being used in an assemble (EXE) entry-point

**Bad** example:

``` csharp
namespace MyStuff.Special {
    // single type inside a namespace
    public class Helper {
    }
}
```
**Good** example:

``` csharp
namespace MyStuff {
    public class Helper {
    }
    // ... many other types ...
}
```
**Configuration**

Some elements of this rule can be customized to better fit your needs.

#### Minimum
The minimum number of types which must exist within a namespace.
