### AvoidUnneededCallsOnStringRule
This rule detects when some methods, like **Clone()**, **Substring(0)**, **ToString()** or **ToString(IFormatProvider)**, are being called on a string instance. Since these calls all return the original string they don't do anything useful and should be carefully reviewed to see if they are working as intended and, if they are, the method call can be removed.

**Bad** example:

``` csharp
public void PrintName (string name)
{
    Console.WriteLine ("Name: {0}", name.ToString ());
}
```
**Good** example:

``` csharp
public void PrintName (string name)
{
    Console.WriteLine ("Name: {0}", name);
}
```
**Notes**

-   Prior to Gendarme 2.0 this rule was more limited and named AvoidToStringOnStringsRule
