### AvoidUnneededFieldInitializationRule
This rule looks for constructors that assign fields to their default value (e.g. 0 for an integer, null for an object or a string). Since the CLR zero initializes all values there is no need, under most circumstances, to assign default values. Doing so only adds size to source code and in IL.

**Bad** example:

``` csharp
public class Bad {
    int i;
    string s;
 
    public Bad ()
    {
        i = 0;
        s = null;
    }
}
```
**Good** example:

``` csharp
public class Good {
    int i;
    string s;
 
    public Good ()
    {
        // don't assign 'i' since it's already 0
        // but we might prefer to assign a string to String.Empty
        s = String.Empty;
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.2
