### AvoidUnusedParametersRule
This rule is used to ensure that all parameters in a method signature are being used. The rule wont report a defect against the following:

-   Methods that are referenced by a delegate;
-   Methods used as event handlers;
-   Abstract methods;
-   Virtual or overriden methods;
-   External methods (e.g. p/invokes)

**Bad** example:

``` csharp
public void MethodWithUnusedParameters (IEnumerable enumerable, int x)
{
    foreach (object item in enumerable) {
        Console.WriteLine (item);
    }
}
```
**Good** example:

``` csharp
public void MethodWithUsedParameters (IEnumerable enumerable)
{
    foreach (object item in enumerable) {
        Console.WriteLine (item);
    }
}
```