### AvoidUnusedPrivateFieldsRule
This rule checks all private fields inside each type to see if some of them are not being used. This could be a leftover from debugging or testing code or a more serious typo where a wrong field is being used. In any case this makes the type bigger than it needs to be which can affect performance when a large number of instances exist.

**Bad** example:

``` csharp
public class Bad {
    int level;
    bool b;
 
    public void Indent ()
    {
        level++;
        #if DEBUG
        if (b) Console.WriteLine (level);
        #endif
    }
}
```
**Good** example:

``` csharp
public class Good {
    int level;
    #if DEBUG
    bool b;
    #endif
 
    public void Indent ()
    {
        level++;
        #if DEBUG
        if (b) Console.WriteLine (level);
        #endif
    }
}
```