### AvoidVisibleConstantFieldRule
This rule looks for constant fields which are visible outside the current assembly. Such fields, if used outside the assemblies, will have their value (not the field reference) copied into the other assembly. Changing the field's value requires that all assemblies which use the field to be recompiled. Declaring the field as **static readonly**, on the other hand, allows the value to be changed without requiring that client assemblies be recompiled.

**Bad** example:

``` csharp
// if this fields is used inside another assembly then
// the integer 42, not the field, will be baked into it
public const int MagicNumber = 42;
```
**Good** example:

``` csharp
// if this field is used inside another assembly then
// that assembly will reference the field instead of
// embedding the value
static public readonly int MagicNumber = 42;
```
**Notes**

-   This rule is available since Gendarme 2.0
