### AvoidVisibleNestedTypesRule
This rule checks for nested types which are externally visible. Such types are often confused with namespaces which makes them more difficult to document and find by developers. In most cases it is better to make these types private or to scope them within a namespace instead of a type.

**Bad** example:

``` csharp
public class Outer {
    public class Inner {
        // ...
    }
}
```
**Good** example (visibility):

``` csharp
public class Outer {
    internal class Inner {
        // ...
    }
}
```
**Good** example (unnested):

``` csharp
public class Outer {
    // ...
}
 
public class Inner {
    // ...
}
```
**Notes**

-   This rule is available since Gendarme 2.0
