### CheckNewThreadWithoutStartRule
This rule checks for threads which are created but not started, or returned or passed to another method as an argument.

**Bad** example:

``` csharp
void UnusedThread ()
{
    Thread thread = new Thread (threadStart);
    thread.Name = "Thread 1";
}
```
**Good** examples:

``` csharp
void Start ()
{
    Thread thread = new Thread (threadStart);
    thread.Name = "Thread 1";
    thread.Start ();
}
 
Thread InitializeThread ()
{
    Thread thread = new Thread (threadStart);
    thread.Name = "Thread 1";
    return thread;
}
```