### CheckParametersNullityInVisibleMethodsRule
This rule checks if all nullable parameters of visible methods are compared with **null** before they get used. This reduce the likelyhood of the runtime throwing a **NullReferenceException**.

**Bad** example:

``` csharp
[DllImport ("message")]
internal static extern byte [] Parse (string s, int length);
 
public bool TryParse (string s, out Message m)
{
    // is 's' is null then 's.Length' will throw a NullReferenceException
    // which a TryParse method should never do
    byte [] data = Parse (s, s.Length);
    if (data == null) {
        m = null;
        return false;
    }
    m = new Message (data);
    return true;
}
```
**Good** example:

``` csharp
[DllImport ("message")]
internal static extern byte [] Parse (string s, int length);
 
public bool TryParse (string s, out Message m)
{
    if (s == null) {
        m = null;
        return false;
    }
    byte [] data = Parse (s, s.Length);
    if (data == null) {
        m = null;
        return false;
    }
    m = new Message (data);
    return true;
}
```
**Notes**

-   This rule is available since Gendarme 2.2
