### CloneMethodShouldNotReturnNullRule
This rule checks for **Clone()** methods which return **null**.

**Bad** example:

``` csharp
public class MyClass : ICloneable {
    public object Clone ()
    {
        MyClass myClass = new MyClass ();
        // set some internals
        return null;
    }
}
```
**Good** example:

``` csharp
public class MyClass : ICloneable {
    public object Clone ()
    {
        MyClass myClass = new MyClass ();
        // set some internals
        return myClass;
    }
}
```