### ConsiderAddingInterfaceRule
This rule fires if a type implements members which are declared in an interface, but the type does not implement the interface. Implementing the interface will normally make the type more reuseable and will help clarify the type's semantics.

**Bad** example:

``` csharp
public interface IDoable {
    public void Do ();
}
 
public class MyClass {
    public void Do ()
    {
    }
}
```
**Good** example:

``` csharp
public interface IDoable {
    public void Do ();
}
 
public class MyClass : IDoable {
    public void Do ()
    {
    }
}
```