### ConsiderConvertingMethodToPropertyRule
This rule checks for methods whose definition looks similar to a property. For example, methods beginning with **Is**, **Get** or **Set** may be better off as properties. But note that this should not be done if the method takes a non-trivial amount of time to execute.

**Bad** example:

``` csharp
public class Bad {
    int foo;
 
    public int GetFoo ()
    {
        return foo;
    }
}
```
**Good** example:

``` csharp
public class Good {
    int foo;
 
    public int Foo {
        get {
            return foo;
        }
    }
}
```