### ConsiderUsingStopwatchRule
This rule checks methods for cases where a **System.Diagnostics.Stopwatch** could be used instead of using **System.DateTime** to compute the time required for an action. Stopwatch is preferred because it better expresses the intent of the code and because (on some platforms at least) StopWatch is accurate to roughly the microsecond whereas DateTime.Now is only accurate to 16 milliseconds or so. This rule only applies to assemblies compiled with the .NET framework version 2.0 (or later).

**Bad** example:

``` csharp
public TimeSpan DoLongOperation ()
{
    DateTime start = DateTime.Now;
    DownloadNewOpenSuseDvdIso ();
    return DateTime.Now - start;
}
```
**Good** example:

``` csharp
public TimeSpan DoLongOperation ()
{
    Stopwatch watch = Stopwatch.StartNew ();
    DownloadNewOpenSuseDvdIso ();
    return watch.Elapsed;
}
```
**Notes**

-   This rule is available since Gendarme 2.0
