### DeclareEventHandlersCorrectlyRule
This rule will fire if an event is declared with a signature which does not match the .NET guidelines. The return type of the event should be void (because there is no good way to handle return values if multiple delegates are attached to the event). And the event should take two arguments. The first should be of type **System.Object** and be named 'sender'. The second should be of type **System.EventArgs** (or a subclass) and named 'e'. This helps tools such as visual designers identify the delegates and methods which may be attached to events. Note that .NET 2.0 added a generic **System.EventHandler**type which can be used to easily create events with the correct signature.

**Bad** example:

``` csharp
// the second parameter (which should be System.EventArgs or a derived class) is missing
delegate void MyDelegate (int sender);
 
class Bad {
    public event MyDelegate CustomEvent;
}
```
**Good** example (delegate):

``` csharp
delegate void MyDelegate (int sender, EventArgs e);
 
class Good {
    public event MyDelegate CustomEvent;
}
```
**Good** example (generics):

``` csharp
class Good {
    public event EventHandler<EventArgs> CustomEvent;
}
```
**Notes**

-   This rule is available since Gendarme 2.2
