### DelegatesPassedToNativeCodeMustIncludeExceptionHandlingRule
Every delegate which is passed to native code must include an exception block which spans the entire method and has a catch all handler.

**Bad** example:

``` csharp
public void NativeCallback ()
{
    Console.WriteLine ("{0}", 1);
}
```
**Good** example:

``` csharp
public void NativeCallback ()
{
    try {
        Console.WriteLine ("{0}", 1);
    }
    catch {
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.6
