### DisableDebuggingCodeRule
This rule checks for non-console applications which contain calls to **Console.WriteLine**. These are often used as debugging aids but such code should be removed or disabled in the released version. If you don't want to remove it altogether you can place it inside a method decorated with **[Conditional ("DEBUG")]**, use **Debug.WriteLine**, use **Trace.WriteLine**, or use the preprocessor. But note that TRACE is often enabled in release builds so if you do use that you'll probably want to use a config file to remove the default trace listener.

**Bad** example:

``` csharp
private byte[] GenerateKey ()
{
    byte[] key = new byte[16];
    rng.GetBytes (key);
    Console.WriteLine ("debug key = {0}", BitConverter.ToString (key));
    return key;
}
```
**Good** example (removed):

``` csharp
private byte[] GenerateKey ()
{
    byte[] key = new byte[16];
    rng.GetBytes (key);
    return key;
}
```
**Good** example (changed):

``` csharp
private byte[] GenerateKey ()
{
    byte[] key = new byte[16];
    rng.GetBytes (key);
    Debug.WriteLine ("debug key = {0}", BitConverter.ToString (key));
    return key;
}
```
**Notes**

-   This rule is available since Gendarme 2.0
