### DoNotDeclareProtectedMembersInSealedTypeRule
This rule ensures that **sealed** types (i.e. types that you can't inherit from) do not define family (**protected** in C#) fields or methods. Instead make the member private so that its accessibility is not misleading.

**Bad** example (field):

``` csharp
public sealed class MyClass {
    protected int someValue;
}
```
**Bad** example (method):

``` csharp
public sealed class MyClass {
    protected int GetAnswer ()
    {
        return 42;
    }
}
```
**Good** example (field):

``` csharp
public sealed class MyClass {
    private int someValue;
}
```
**Good** example (method):

``` csharp
public sealed class MyClass {
    private int GetAnswer ()
    {
        return 42;
    }
}
```
**Notes**

-   Prior to Gendarme 2.2 this rule applied only to fields and was named DoNotDeclareProtectedFieldsInSealedClassRule
