### DoNotExposeFieldsInSecuredTypeRule
The rule checks for types that are secured by **Demand** or **LinkDemand**but also expose visible fields. Access to these fields is not covered by the declarative demands, opening potential security holes.

**Bad** example:

``` csharp
[SecurityPermission (SecurityAction.LinkDemand, ControlThread = true)]
public class Bad {
}
```
**Good** example (InheritanceDemand):

``` csharp
[SecurityPermission (SecurityAction.LinkDemand, ControlThread = true)]
[SecurityPermission (SecurityAction.InheritanceDemand, ControlThread = true)]
public class Correct {
}
```
**Good** example (sealed):

``` csharp
[SecurityPermission (SecurityAction.LinkDemand, ControlThread = true)]
public sealed class Correct {
}
```
**Notes**

-   Before Gendarme 2.2 this rule was part of Gendarme.Rules.Security and named TypeExposeFieldsRule.
