### DoNotExposeMethodsProtectedByLinkDemandRule
This rule checks for visible methods that are less protected (i.e. lower security requirements) than the method they call. If the called methods are protected by a **LinkDemand** then the caller can be used to bypass security checks.

**Bad** example:

``` csharp
public class BaseClass {
    [SecurityPermission (SecurityAction.LinkDemand, Unrestricted = true)]
    public virtual void VirtualMethod ()
    {
    }
}
 
public class Class : BaseClass  {
    // bad since a caller with only ControlAppDomain will be able to call the base method
    [SecurityPermission (SecurityAction.LinkDemand, ControlAppDomain = true)]
    public override void VirtualMethod ()
    {
        base.VirtualMethod ();
    }
}
```
**Good** example (InheritanceDemand):

``` csharp
public class BaseClass {
    [SecurityPermission (SecurityAction.LinkDemand, ControlAppDomain = true)]
    public virtual void VirtualMethod ()
    {
    }
}
 
public class Class : BaseClass  {
    // ok since this permission cover the base class permission
    [SecurityPermission (SecurityAction.LinkDemand, Unrestricted = true)]
    public override void VirtualMethod ()
    {
        base.VirtualMethod ();
    }
}
```
**Notes**

-   Before Gendarme 2.2 this rule was part of Gendarme.Rules.Security and named MethodCallWithSubsetLinkDemandRule.
