### DoNotLockOnWeakIdentityObjectsRule
This rule ensures there are no locks on objects with weak identity. An object with weak identity is one that can be directly accessed across different application domains. Because these objects can be accessed by different application domains it is very difficult to ensure that the locking is done correctly so problems such as deadlocks are much more likely. The following types have a weak identities:

-   **System.MarshalByRefObject**
-   **System.OutOfMemoryException**
-   **System.Reflection.MemberInfo**
-   **System.Reflection.ParameterInfo**
-   **System.ExecutionEngineException**
-   **System.StackOverflowException**
-   **System.String**
-   **System.Threading.Thread**

**Bad** example:

``` csharp
public void WeakIdLocked ()
{
    lock ("CustomString") {
        // ...
    }
}
```
**Good** example:

``` csharp
public void WeakIdNotLocked ()
{
    Phone phone = new Phone ();
    lock (phone) {
        // ...
    }
}
```