### DoNotPrefixEventsWithAfterOrBeforeRule
This rule ensures that event names are not prefixed with **After** or **Before**. The .NET naming conventions recommend using a verb in the present and in the past tense.

**Bad** example:

``` csharp
public class Bad {
    public event ResolveEventHandler BeforeResolve;
    public event ResolveEventHandler AfterResolve;
}
```
**Good** example:

``` csharp
public class Good {
    public event ResolveEventHandler Resolving;    // present
    public event ResolveEventHandler Resolved; // past
}
```