### DoNotThrowReservedExceptionRule
This rule will fire if an **System.ExecutionEngineException**, **System.IndexOutOfRangeException**, **NullReferenceException**, or **System.OutOfMemoryException** class is instantiated. These exceptions are for use by the runtime and should not be thrown by user code.

**Bad** example:

``` csharp
public void Add (object obj)
{
    if (obj == null) {
        throw new NullReferenceException ("obj");
    }
    Inner.Add (obj);
}
```
**Good** example:

``` csharp
public void Add (object obj)
{
    if (obj == null) {
        throw new ArgumentNullException ("obj");
    }
    Inner.Add (obj);
}
```
**Notes**

-   This rule is available since Gendarme 2.0
