### DoNotUseMethodImplOptionsSynchronizedRule
This rule fires if a method is decorated with **[MethodImpl(MethodImplOptions.Synchronized)]**. The runtime synchronizes those methods automatically using a **lock(this)** for instance methods or a **lock(typeof(X))** for static methods. This can cause problems because anyone can acquire a lock on the instance or type. And if another thread does acquire a lock then deadlocks become a very real possibility. The preferred way to handle this is to create a private **System.Object** instance field and **lock** that. This greatly reduces the scope of the code which may acquire the lock which makes it much easier to ensure that the locking is done correctly.

**Bad** example:

``` csharp
[MethodImpl (MethodImplOptions.Synchronized)]
public void SychronizedMethod ()
{
    producer++;
}
```
**Good** example:

``` csharp
public class ClassWithALocker {
    object locker = new object ();
    int producer = 0;
 
    public void MethodLockingLocker ()
    {
        lock (locker) {
            producer++;
        }
    }
}
```