### EnsureLocalDisposalRule
This rule checks that disposable locals are always disposed of before the method returns. Use a 'using' statement (or a try/finally block) to guarantee local disposal even in the event an unhandled exception occurs.

**Bad** example (non-guaranteed disposal):

``` csharp
void DecodeFile (string file)
{
    var stream = new StreamReader (file);
    DecodeHeader (stream);
    if (!DecodedHeader.HasContent) {
        return;
    }
    DecodeContent (stream);
    stream.Dispose ();
}
```
**Good** example (non-guaranteed disposal):

``` csharp
void DecodeFile (string file)
{
    using (var stream = new StreamReader (file)) {
        DecodeHeader (stream);
        if (!DecodedHeader.HasContent) {
            return;
        }
        DecodeContent (stream);
    }
}
```
**Bad** example (not disposed of / not locally disposed of):

``` csharp
void DecodeFile (string file)
{
    var stream = new StreamReader (file);
    Decode (stream);
}
 
void Decode (Stream stream)
{
    /*code to decode the stream*/
    stream.Dispose ();
}
```
**Good** example (not disposed of / not locally disposed of):

``` csharp
void DecodeFile (string file)
{
    using (var stream = new StreamReader (file)) {
        Decode (stream);
    }
}
 
void Decode (Stream stream)
{
    /*code to decode the stream*/
}
```
**Notes**

-   This rule is available since Gendarme 2.4
