### ExceptionShouldBeVisibleRule
This rule checks for non-visible exceptions which derive directly from the most basic exceptions: **System.Exception**, **System.ApplicationException**or **System.SystemException**. Those basic exceptions, being visible, will be the only information available to the API consumer - but do not contain enough data to be useful.

**Bad** example:

``` csharp
internal class GeneralException : Exception {
}
```
**Good** example (visibility):

``` csharp
public class GeneralException : Exception {
}
```
**Good** example (base class):

``` csharp
internal class GeneralException : ArgumentException {
}
```
**Notes**

-   This rule is available since Gendarme 2.0
