### ExitCodeIsLimitedOnUnixRule
This rule applies to all executable (i.e. EXE) assemblies. Something that many Windows developers might not be aware of is that on Unix systems, process exit code must be between zero and 255, unlike in Windows where it can be any valid integer value. This rule warns if the returned value might be out of range either by:

-   returning an unknown value from **int Main()**;
-   setting the **Environment.ExitCode** property; or
-   calling **Environment.Exit(exitCode)** method.

An error is reported in case a number which is definitely out of range is returned as an exit code.

**Bad** example:

``` csharp
class MainClass {
    static int Main ()
    {
        Environment.ExitCode = 1000;
        Environment.Exit (512);
        return -1;
    }
}
```
**Good** example:

``` csharp
class MainClass {
    static int Main ()
    {
        Environment.ExitCode = 42;
        Environment.Exit (100);
        return 1;
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
