### FeatureRequiresRootPrivilegeOnUnixRule
This rule fires if a feature is used which is, by default, restricted under Unix.

-   **System.Net.NetworkInformation.Ping**: This type can only be used by root on Unix systems. As an alternative you can execute the ping command and parse its result.
-   **System.Diagnostics.Process**: The PriorityClass property can only be set to **Normal** by non-root users. To avoid this problem you can do a platform check before assigning a priority.

**Bad** example:

``` csharp
process.PriorityClass = ProcessPriorityClass.AboveNormal;
process.Start ();
```
**Good** example:

``` csharp
if (Environment.OSVersion.Platform != PlatformID.Unix) {
    process.PriorityClass = ProcessPriorityClass.AboveNormal;
}
process.Start ();
```