### ImplementEqualsTypeRule
This rule looks for types that override **Object.Equals(object)** but do not provide a **Equals(x)** overload using the type. Such an overload removes the need to cast the object to the correct type. For value types this also removes the costly boxing operations. Assemblies targeting .NET 2.0 (and later) should also implement **System.IEquatable\<T\>**.

**Bad** example:

``` csharp
public class Bad {
    public override bool Equals (object obj)
    {
        return base.Equals (obj);
    }
 
    public override int GetHashCode ()
    {
        return base.GetHashCode ();
    }
}
```
**Good** example:

``` csharp
// IEquatable<T> is only available since
// version 2.0 of the .NET framework
public class Good : IEquatable<Good> {
    public override bool Equals (object obj)
    {
        return (obj as Good);
    }
 
    public bool Equals (Good other)
    {
        return (other != null);
    }
 
    public override int GetHashCode ()
    {
        return base.GetHashCode ();
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
