### ImplementICloneableCorrectlyRule
This rule fires if you implement a **object Clone()** method without implementing the **System.ICloneable** interface. Either change the method so that it returns a better type than System.Object or implement ICloneable.

**Bad** example:

``` csharp
public class MyClass {
    public object Clone ()
    {
        MyClass myClass = new MyClass ();
        return myClass;
    }
}
```
**Good** example (ICloneable):

``` csharp
public class MyClass : ICloneable {
    public object Clone ()
    {
        MyClass myClass = new MyClass ();
        return myClass;
    }
}
```
**Good** example (not returning System.Object):

``` csharp
public class MyClass {
    public MyClass Clone ()
    {
        MyClass myClass = new MyClass ();
        return myClass;
    }
}
```
**Notes**

-   Prior to Gendarme 2.2 this rule was named UsingCloneWithoutImplementingICloneableRule
