### ImplementIComparableCorrectlyRule
This rule checks for types that implement **System.IComparable** and verifies that the type overrides the **Equals(object)** method and overloads the **==**, **!=**, **\<** and **\>** operators.

**Bad** example:

``` csharp
public struct Comparable : IComparable {
 
    private int x;
 
    public int CompareTo (object obj)
    {
        return x.CompareTo (((Comparable)obj).x);
    }
}
```
**Good** example:

``` csharp
public struct Comparable : IComparable {
 
    public int CompareTo (object obj)
    {
        return x.CompareTo (((Comparable)obj).x);
    }
 
    public override bool Equals (object obj)
    {
        return x == ((Comparable) obj).x;
    }
 
    static public bool operator == (Comparable left, Comparable right)
    {
        return (left.x == right.x);
    }
 
    static public bool operator != (Comparable left, Comparable right)
    {
        return (left.x != right.x);
    }
 
    static public bool operator > (Comparable left, Comparable right)
    {
        return (left.x > right.x);
    }
 
    static public bool operator < (Comparable left, Comparable right)
    {
        return (left.x < right.x);
    }
}
```
**Notes**

-   This rule is available since Gendarme 2.0
